#include <bits/stdc++.h>
using namespace std;

using ll = long long;

struct Jarbol {
    ll x, h;
    int id;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<Jarbol> a(n);
    for(int i = 0; i < n; i++) {
        cin >> a[i].x;
        a[i].id = i;
    }
    for(int i = 0; i < n; i++)
        cin >> a[i].h;

    sort(a.begin(), a.end(), [](auto &A, auto &B){
        return A.x < B.x;
    });

    vector<ll> ans(n, (ll)-1);

    auto dist = [&](int i, int j) {
        return llabs(a[i].x - a[j].x) + llabs(a[i].h - a[j].h);
    };

    {
        vector<int> st;
        for(int i = 0; i < n; i++) {
            while(!st.empty()) {
                int j = st.back();
        
                if (a[j].h - llabs(a[j].x - a[i].x) >= a[i].h) break;
                st.pop_back();
            }
            if(!st.empty()) {
                int j = st.back();
                ans[a[i].id] = dist(i, j);
            }
            st.push_back(i);
        }
    }

 
    {
        vector<int> st;
        for(int i = n-1; i >= 0; i--) {
            while(!st.empty()) {
                int j = st.back();
                if (a[j].h - llabs(a[j].x - a[i].x) >= a[i].h) break;
                st.pop_back();
            }
            if(!st.empty()) {
                int j = st.back();
                ll d = dist(i, j);
                if (ans[a[i].id] == -1 || d < ans[a[i].id])
                    ans[a[i].id] = d;
            }
            st.push_back(i);
        }
    }

 
    for (int i = 0; i < n; i++)
        cout << ans[i] << "\n";

    return 0;
}